#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using System.Collections;
using System.IO;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.Core.Logging;
using System.Collections.Specialized;
using System.Linq;

#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "OrderedDictionary", Category = "ID", 
	Help = "Gets First IDs by order of appearance and avoid the rest", 
	Tags = "ID,Dictionary",Author = "colorsound")]
	#endregion PluginInfo
	public class spreadOrderedDictionaryContainsNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Key", DefaultValue = 1.0, Order = 0)]
		ISpread<int> FKey;

		[Input("Value", DefaultValue = 1.0, Order = 1)]
		ISpread<int> FValue;

		[Input("RemoveKey", Order = 2)]
		ISpread<int> FRemoveKey;

		[Input("Reset", DefaultValue = 0, IsSingle = true, Order = 3)]
		ISpread<bool> FReset;

		[Output("keyOut", Order = 0)]
		ISpread<int> FKeyOut;

		[Output("valueOut", Order = 1)]
		ISpread<int> FValueOut;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		OrderedDictionary Dicti = new OrderedDictionary();

		int countAdd = 0; // Variable for storing FKey.SliceCount of Input Pin Key
		int dicount = 0;  // Variable for storing Dictionary Count
		int countRemove = 0; //Variable for storing FRemoveKey.SliceCount of Input Pin Value
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
            //Get sliceCount on Input pins
			countAdd =  FKey.SliceCount;
			countRemove =  FRemoveKey.SliceCount;


			
             //Add a Key and Value if the Key does not exist 
			// If the key exist Ignore it 
				for (int i = 0; i < countAdd; i++) 
			{

				if (!Dicti.Contains(FKey[i])) 
				{
				    Dicti.Add(FKey[i], FValue[i]);
				}
			}

           // If the key enter exist In the Remove Key Input Pin then Remove it
				for (int i = 0; i < countRemove; i++) 
			{

				if (Dicti.Contains(FRemoveKey[i])) 
				{
						Dicti.Remove(FRemoveKey[i]);
				}
			}

			//Reset the Dictionary If the Input Pin Reset is set .
			if (FReset[0]) {
				Dicti.Clear();
			}
            
			// Get dictionary Count 
			dicount = Dicti.Count;
            // Set Same count to Output Pins 
			FKeyOut.SliceCount = dicount;
			FValueOut.SliceCount = dicount;
            // Make array of ints of same size of Dictionary Count
			int[] keys = new int[dicount];
			int[] values = new int[dicount];
			//Copy keys and values to Array 
			Dicti.Keys.CopyTo(keys, 0);
			Dicti.Values.CopyTo(values, 0);
			// Set those values to Output Pins 
			for (int i = 0; i < dicount; i++) 
			{

				FKeyOut[i] = keys[i];
				FValueOut[i] = values[i];
			}

		}
	}
}
